/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.pdftool;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.awt.Color;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;

public class HtmlToPdfConverter {
    public static void main(String[] args) throws Exception {
        String html = "<html><body><h1>Hello, 2026-!</h1><p>Text goes <em>here</em> and maybe this will wrap the text.</p><p>And now we need more text just to see if this will span a page.</p><ul><li>How about a list too</li><li>2nd item</li><li>3rd item here</li></ul></body></html>";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fontSize", 8.0);
        HtmlToPdfConverter.writePDFToHtml(Files.createTempFile("test", ".tmp", new FileAttribute[0]), html, map);
    }

    public static boolean writePDFToHtml(Path fullPathAndFile, String html, Map<String, Object> settings) throws Exception {
        boolean rotated = false;
        double fontSize = (Double)settings.get("fontSize");
        double minFontSize = (Double)settings.get("fontMinSize");
        double fontTitleSize = (Double)settings.get("fontTitleSize");
        Color borderColor = (Color)settings.get("borderColor");
        String borderColorString = String.format("#%02x%02x%02x", borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue());
        PdfRendererBuilder builder = new PdfRendererBuilder();
        HtmlToPdfConverter.embedFont("fonts/damase_v2.ttf", builder, "Damase v2");
        HtmlToPdfConverter.embedFont("fonts/BLKCHCRY.ttf", builder, "Black Chancery");
        int pageCount = 2;
        int count = HtmlToPdfConverter.countTableHeadings(html);
        if (count > 4000) {
            rotated = true;
        }
        while (pageCount > 1 && fontSize >= minFontSize) {
            Document jsoupDoc = Jsoup.parse(html);
            jsoupDoc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
            jsoupDoc.head().append("<style> @page { margin: 0.1in; background-color: " + borderColorString + "; } body { background-color: white; margin: 0.025in; font-size: " + fontSize + "pt; line-height: 1;} ul,ol { padding-left: 1em; margin-left: 0; margin-bottom: " + fontSize / 3.0 + "pt; } h1,h2,h3 {font-family: 'Black Chancery'; margin-top: 0; margin-bottom: 3pt; font-size: " + fontTitleSize + "pt; } p,li,h4,h5,h6 {font-family: 'Damase v2'; sans-serif; margin-top: 0; margin-bottom: " + fontSize / 3.0 + "pt; } li { margin-bottom: 0pt; } </style>");
            System.out.println("jsoup:" + String.valueOf(jsoupDoc.head()));
            W3CDom w3cDom = new W3CDom();
            org.w3c.dom.Document doc = w3cDom.fromJsoup(jsoupDoc);
            if (rotated) {
                builder.useDefaultPageSize(3.5f, 2.5f, BaseRendererBuilder.PageSizeUnits.INCHES);
            } else {
                builder.useDefaultPageSize(2.5f, 3.5f, BaseRendererBuilder.PageSizeUnits.INCHES);
            }
            builder.withW3cDocument(doc, null);
            PdfBoxRenderer renderer = builder.buildPdfRenderer();
            renderer.layout();
            pageCount = renderer.getRootBox().getLayer().getPages().size();
            System.out.println("pageCount:" + pageCount);
            fontSize -= 0.25;
        }
        try (FileOutputStream os = new FileOutputStream(fullPathAndFile.toFile());){
            builder.toStream(os);
            builder.run();
        }
        return rotated;
    }

    private static void embedFont(String fontFilename, PdfRendererBuilder builder, String fontFamily) {
        URL font1Url = HtmlToPdfConverter.class.getClassLoader().getResource(fontFilename);
        if (font1Url != null) {
            builder.useFont(() -> {
                try {
                    return font1Url.openStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to load font from classpath", e);
                }
            }, fontFamily);
        }
    }

    private static int countTableHeadings(String html) {
        String subString = "<th>";
        int originalLength = html.length();
        int lengthWithoutSubstring = html.replace(subString, "").length();
        int count = (originalLength - lengthWithoutSubstring) / subString.length();
        return count;
    }
}

