/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.pdftool;

import com.inkwellideas.pdftool.RPGCardCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JCheckBoxTree
extends JTree {
    private static final long serialVersionUID = -4194122328392241790L;
    JCheckBoxTree selfPointer = this;
    HashMap<TreePath, CheckedNode> nodesCheckingState;
    HashSet<TreePath> checkedPaths = new HashSet();
    protected EventListenerList listenerList = new EventListenerList();

    public void addCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.add(CheckChangeEventListener.class, listener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.remove(CheckChangeEventListener.class, listener);
    }

    void fireCheckChangeEvent(CheckChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)listeners[i + 1]).checkStateChanged(evt);
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.resetCheckingState();
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[this.checkedPaths.size()]);
    }

    public boolean isSelectedPartially(TreePath path) {
        CheckedNode cn = this.nodesCheckingState.get(path);
        return cn.isSelected && cn.hasChildren && !cn.allChildrenSelected;
    }

    private void resetCheckingState() {
        this.nodesCheckingState = new HashMap();
        this.checkedPaths = new HashSet();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(node);
    }

    private void addSubtreeToCheckingStateTracking(DefaultMutableTreeNode node) {
        Object[] path = node.getPath();
        TreePath tp = new TreePath(path);
        CheckedNode cn = new CheckedNode(this, false, node.getChildCount() > 0, false);
        this.nodesCheckingState.put(tp, cn);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addSubtreeToCheckingStateTracking((DefaultMutableTreeNode)tp.pathByAddingChild(node.getChildAt(i)).getLastPathComponent());
        }
    }

    public JCheckBoxTree(DefaultTreeModel model) {
        super(model);
        this.setToggleClickCount(0);
        CheckBoxCellRenderer cellRenderer = new CheckBoxCellRenderer();
        this.setCellRenderer(cellRenderer);
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -8190634240451667286L;

            @Override
            public void setSelectionPath(TreePath path) {
            }

            @Override
            public void addSelectionPath(TreePath path) {
            }

            @Override
            public void removeSelectionPath(TreePath path) {
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
            }
        };
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath tp = JCheckBoxTree.this.selfPointer.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (tp == null) {
                    return;
                }
                if (mouseEvent.getButton() == 3) {
                    System.out.println("button 3:" + String.valueOf(tp.getClass()) + ":" + String.valueOf(tp));
                    String title = "";
                    for (Object part : tp.getPath()) {
                        title = part.toString();
                    }
                    JPanel inputPanel = new JPanel();
                    JLabel titleLabel = new JLabel("Node Title:");
                    inputPanel.add(titleLabel);
                    JTextField titleField = new JTextField(title);
                    inputPanel.add(titleField);
                    Object[] options = new Object[]{"Apply", "Cancel"};
                    int choice = JOptionPane.showOptionDialog(RPGCardCreator.frame, inputPanel, "Change Node Title", 0, 3, null, options, options[0]);
                    System.out.println("choice: " + choice);
                    if (choice == 0) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPath()[tp.getPath().length - 1];
                        LinkedHashMap dataMap = RPGCardCreator.masterMap;
                        String part = "";
                        LinkedHashMap parentDataMap = null;
                        for (int i = 1; i < tp.getPath().length; ++i) {
                            parentDataMap = dataMap;
                            part = tp.getPath()[i].toString();
                            dataMap = (LinkedHashMap)dataMap.get(part);
                            System.out.println("pre:" + part + ":" + String.valueOf(dataMap));
                        }
                        parentDataMap.put((String)titleField.getText(), dataMap);
                        System.out.println("replaced:" + part + " with:" + titleField.getText() + " data:\n" + String.valueOf(dataMap));
                        ((DefaultTreeModel)JCheckBoxTree.this.treeModel).nodeStructureChanged(node);
                        node.setUserObject(titleField.getText());
                    }
                }
                boolean checkMode = !JCheckBoxTree.this.nodesCheckingState.get((Object)tp).isSelected;
                JCheckBoxTree.this.checkSubTree(tp, checkMode);
                JCheckBoxTree.this.updatePredecessorsWithCheckMode(tp, checkMode);
                JCheckBoxTree.this.fireCheckChangeEvent(new CheckChangeEvent(tp));
                JCheckBoxTree.this.selfPointer.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.setSelectionModel(dtsm);
    }

    protected void updatePredecessorsWithCheckMode(TreePath tp, boolean check) {
        TreePath parentPath = tp.getParentPath();
        if (parentPath == null) {
            return;
        }
        CheckedNode parentCheckedNode = this.nodesCheckingState.get(parentPath);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        parentCheckedNode.allChildrenSelected = true;
        parentCheckedNode.isSelected = false;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreePath childPath = parentPath.pathByAddingChild(parentNode.getChildAt(i));
            CheckedNode childCheckedNode = this.nodesCheckingState.get(childPath);
            if (!childCheckedNode.allChildrenSelected) {
                parentCheckedNode.allChildrenSelected = false;
            }
            if (!childCheckedNode.isSelected) continue;
            parentCheckedNode.isSelected = true;
        }
        if (parentCheckedNode.isSelected) {
            this.checkedPaths.add(parentPath);
        } else {
            this.checkedPaths.remove(parentPath);
        }
        this.updatePredecessorsWithCheckMode(parentPath, check);
    }

    protected void checkSubTree(TreePath tp, boolean check) {
        CheckedNode cn = this.nodesCheckingState.get(tp);
        cn.isSelected = check;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.checkSubTree(tp.pathByAddingChild(node.getChildAt(i)), check);
        }
        cn.allChildrenSelected = check;
        if (check) {
            this.checkedPaths.add(tp);
        } else {
            this.checkedPaths.remove(tp);
        }
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public class CheckChangeEvent
    extends EventObject {
        private static final long serialVersionUID = -8100230309044193368L;

        public CheckChangeEvent(Object source) {
            super(source);
        }
    }

    private class CheckedNode {
        boolean isSelected;
        boolean hasChildren;
        boolean allChildrenSelected;

        public CheckedNode(JCheckBoxTree jCheckBoxTree, boolean isSelected_, boolean hasChildren_, boolean allChildrenSelected_) {
            this.isSelected = isSelected_;
            this.hasChildren = hasChildren_;
            this.allChildrenSelected = allChildrenSelected_;
        }
    }

    private class CheckBoxCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7341833835878991719L;
        JCheckBox checkBox;

        public CheckBoxCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.add((Component)this.checkBox, "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            TreePath tp = new TreePath(node.getPath());
            CheckedNode cn = JCheckBoxTree.this.nodesCheckingState.get(tp);
            if (cn == null) {
                return this;
            }
            this.checkBox.setSelected(cn.isSelected);
            this.checkBox.setText(obj.toString());
            this.checkBox.setOpaque(cn.isSelected && cn.hasChildren && !cn.allChildrenSelected);
            return this;
        }
    }
}

