/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.pdftool;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Block;
import org.commonmark.node.Heading;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.Renderer;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.markdown.MarkdownRenderer;

public class MarkdownParserToTreeMap {
    public static final String CONTENT_KEY = "*content*";

    public static void main(String[] args) {
        String markdown = "# Level 1\nSome text for _L1_.\n## Level 2\nText for L2.\n# Level 1 Part B";
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        MarkdownParserToTreeMap.parseToHTML(root, markdown);
        System.out.println(root);
        String html = MarkdownParserToTreeMap.convertMarkdownToHtml(markdown);
        System.out.println(html);
    }

    public static String convertMarkdownToHtml(String markdown) {
        List<Extension> extensions = Collections.singletonList(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        Node document = parser.parse(markdown);
        HtmlRenderer renderer = HtmlRenderer.builder().extensions(extensions).build();
        return renderer.render(document);
    }

    public static void parseToHTML(LinkedHashMap<String, Object> root, String markdown) {
        HtmlRenderer renderer = HtmlRenderer.builder().omitSingleParagraphP(true).build();
        MarkdownParserToTreeMap.parse(root, markdown, renderer);
    }

    public static void parseToMarkdownWithStructure(LinkedHashMap<String, Object> root, String markdown) {
        MarkdownRenderer renderer = MarkdownRenderer.builder().build();
        MarkdownParserToTreeMap.parse(root, markdown, renderer);
    }

    public static void parse(LinkedHashMap<String, Object> root, String markdown, Renderer renderer) {
        Parser parser = Parser.builder().build();
        Node document = parser.parse(markdown);
        ArrayDeque<LevelContext> stack = new ArrayDeque<LevelContext>();
        stack.push(new LevelContext(0, root));
        for (Node node = document.getFirstChild(); node != null; node = node.getNext()) {
            if (node instanceof Heading) {
                Heading h = (Heading)node;
                String title = MarkdownParserToTreeMap.extractHeadingText(h);
                int level = h.getLevel();
                while (((LevelContext)stack.peek()).level >= level) {
                    stack.pop();
                }
                LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                newMap.put(CONTENT_KEY, new StringBuilder());
                ((LevelContext)stack.peek()).map.put(title, newMap);
                stack.push(new LevelContext(level, newMap));
                continue;
            }
            if (stack.isEmpty() || ((LevelContext)stack.peek()).level <= 0) continue;
            StringBuilder content = (StringBuilder)((LevelContext)stack.peek()).map.get(CONTENT_KEY);
            String renderedNode = renderer.render(node);
            content.append(renderedNode);
            if (!(node instanceof Block) || node instanceof Heading) continue;
            content.append("\n\n");
        }
    }

    private static String extractHeadingText(Heading heading) {
        StringBuilder sb = new StringBuilder();
        for (Node child = heading.getFirstChild(); child != null; child = child.getNext()) {
            if (!(child instanceof Text)) continue;
            sb.append(((Text)child).getLiteral());
        }
        return sb.toString();
    }

    private static class LevelContext {
        int level;
        LinkedHashMap<String, Object> map;

        LevelContext(int l, LinkedHashMap<String, Object> m) {
            this.level = l;
            this.map = m;
        }
    }
}

