/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.pdftool;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Scanner;
import javax.imageio.ImageIO;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class MultipleCardsPerPagePDF {
    public static void main(String[] args) {
        System.out.println("Enter full path and file name:");
        Scanner scanner = new Scanner(System.in);
        String filename = scanner.nextLine();
        File pdfFile = new File(filename);
        int[] up9 = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 5, 3, 1, 11, 9, 7, 17, 15, 13};
        if (pdfFile.isDirectory()) {
            for (File f : pdfFile.listFiles()) {
                if (!f.getName().endsWith(".pdf")) continue;
                MultipleCardsPerPagePDF.processFile(f.getAbsolutePath(), f, "letter", up9);
            }
        } else {
            MultipleCardsPerPagePDF.processFile(filename, pdfFile, "letter", up9);
        }
    }

    public static void processFile(String outputFilename, File inputPDFFile, String pageSize, int[] ordering) {
        PDRectangle pageRectangle = PDRectangle.A4;
        int marginX = 24;
        int marginY = 36;
        if (pageSize.toLowerCase().contains("letter")) {
            pageRectangle = PDRectangle.LETTER;
            marginX = 33;
            marginY = 15;
        }
        try {
            PDDocument sourceDocument = Loader.loadPDF(inputPDFFile);
            PDRectangle pdf1Frame = sourceDocument.getPage(0).getCropBox();
            if (pageSize.equals("Images")) {
                MultipleCardsPerPagePDF.makeImagesOfEachPage(outputFilename, inputPDFFile);
            } else {
                MultipleCardsPerPagePDF.makeXByYPages(sourceDocument, pageRectangle, pageSize, 3, 3, ordering, marginX, marginY, outputFilename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void makeXByYPages(PDDocument sourceDocument, PDRectangle pageSize, String pageSizeString, int pagesPerRow, int pagesPerColumn, int[] pageOrdering, int marginWidth, int marginHeight, String filename) {
        try {
            PDDocumentInformation info = sourceDocument.getDocumentInformation();
            String author = info.getAuthor();
            String title = info.getTitle();
            int numberOfSourcePages = sourceDocument.getNumberOfPages();
            PDDocument outputDocument = new PDDocument();
            outputDocument.getDocumentInformation().setAuthor(author);
            outputDocument.getDocumentInformation().setTitle(title);
            PDRectangle pdf1Frame = sourceDocument.getPage(0).getCropBox();
            float widthGap = (pageSize.getWidth() - (float)pagesPerRow * pdf1Frame.getWidth() - (float)(marginWidth * 2)) / (float)(pagesPerRow - 1);
            float heightGap = (pageSize.getHeight() - (float)pagesPerColumn * pdf1Frame.getHeight() - (float)(marginHeight * 2)) / (float)(pagesPerColumn - 1);
            int pageCount = 0;
            PDFMergerUtility mergerUtility = new PDFMergerUtility();
            while (pageCount < numberOfSourcePages) {
                for (int side = 0; side < 2; ++side) {
                    PDDocument tempDocument = new PDDocument();
                    LayerUtility layerUtility = new LayerUtility(tempDocument);
                    COSDictionary dict = new COSDictionary();
                    dict.setItem(COSName.TYPE, (COSBase)COSName.PAGE);
                    dict.setItem(COSName.MEDIA_BOX, (COSObjectable)pageSize);
                    dict.setItem(COSName.CROP_BOX, (COSObjectable)pageSize);
                    dict.setItem(COSName.ART_BOX, (COSObjectable)pageSize);
                    PDPage outPdfPage = new PDPage(dict);
                    tempDocument.addPage(outPdfPage);
                    for (int row = 0; row < pagesPerRow; ++row) {
                        for (int col = 0; col < pagesPerColumn; ++col) {
                            int pageNumBase = pageCount;
                            int subPageNum = side * pagesPerColumn * pagesPerRow + (row * pagesPerColumn + col);
                            if ((pageNumBase -= subPageNum) + (subPageNum = pageOrdering[subPageNum]) < sourceDocument.getNumberOfPages()) {
                                PDFormXObject formPdf1 = layerUtility.importPageAsForm(sourceDocument, pageNumBase + subPageNum);
                                AffineTransform af = AffineTransform.getTranslateInstance((float)marginWidth + (float)col * pdf1Frame.getWidth() + widthGap * (float)col, (float)marginHeight + ((float)(pagesPerRow - row - 1) * pdf1Frame.getHeight() + heightGap * (float)(pagesPerRow - row - 1)));
                                layerUtility.appendFormAsLayer(outPdfPage, formPdf1, af, pageCount + "-" + row + "-" + col);
                            }
                            ++pageCount;
                        }
                    }
                    mergerUtility.appendDocument(outputDocument, tempDocument);
                }
            }
            outputDocument.save(filename);
            outputDocument.close();
            sourceDocument.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void makeImagesOfEachPage(String filename, File pdfFile) {
        File outputDir = new File(filename);
        outputDir.mkdirs();
        try {
            PDDocument document = Loader.loadPDF(pdfFile);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            for (int pageIndex = 0; pageIndex < document.getNumberOfPages(); ++pageIndex) {
                BufferedImage bim = pdfRenderer.renderImageWithDPI(pageIndex, 300.0f, ImageType.RGB);
                String outputPath = String.valueOf(outputDir) + "/card_" + pageIndex + ".png";
                ImageIO.write((RenderedImage)bim, "PNG", new File(outputPath));
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

