/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.pdftool;

import com.inkwellideas.pdftool.HtmlToPdfConverter;
import com.inkwellideas.pdftool.JCheckBoxTree;
import com.inkwellideas.pdftool.MarkdownParserToTreeMap;
import com.inkwellideas.pdftool.MultipleCardsPerPagePDF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class RPGCardCreator {
    static Properties prop = new Properties();
    static LinkedHashMap<String, Object> masterMap = new LinkedHashMap();
    static JCheckBoxTree tree;
    static DefaultTreeModel treeModel;
    static TreePath selectedTreePath;
    static JTextArea textArea;
    static double version;
    static JFrame frame;
    static JScrollPane treeScrollPane;
    static HashMap<String, Object> settingsMap;
    static String dataSet;
    private static JSpinner fontTitleSizeSpinner;
    private static JSpinner fontSizeSpinner;
    private static JSpinner fontMinSizeSpinner;
    private static Color[] borderColor;
    private static JComboBox<String> pageSizeComboBox;

    public static void main(String[] args) {
        masterMap = (LinkedHashMap)RPGCardCreator.ingestMarkDown(dataSet);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RPGCardCreator.createAndShowGUI();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String createPDF() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        int userSelection = fileChooser.showSaveDialog(frame);
        if (userSelection != 0) return "PDF creation cancelled.";
        String pageSize = (String)settingsMap.get("pageSize");
        File fileToSave = fileChooser.getSelectedFile();
        String multipleCardsPerPageFileName = fileToSave.getAbsolutePath();
        if (!pageSize.toLowerCase().contains("us poker card")) {
            fileToSave = new File(multipleCardsPerPageFileName + ".tmp");
        }
        float width = 180.0f;
        float height = 252.0f;
        PDRectangle customPageSize = new PDRectangle(width, height);
        ArrayList<Path> pathAndFiles = new ArrayList<Path>();
        ArrayList<File> rotatedFiles = new ArrayList<File>();
        try {
            TreePath[] paths = tree.getCheckedPaths();
            String heading = "";
            for (TreePath tp : paths) {
                LinkedHashMap selectedMap = null;
                for (Object pathPart : tp.getPath()) {
                    Object result;
                    if (dataSet.equals(pathPart.toString())) {
                        selectedMap = masterMap;
                        continue;
                    }
                    if (!pathPart.toString().contains("*content*")) {
                        heading = pathPart.toString();
                    }
                    if ((result = selectedMap.get(pathPart.toString())) == null) continue;
                    if (result instanceof LinkedHashMap) {
                        LinkedHashMap tm;
                        selectedMap = tm = (LinkedHashMap)result;
                        continue;
                    }
                    if (!(result instanceof StringBuilder)) continue;
                    StringBuilder stringBuilder = (StringBuilder)result;
                    Object html = MarkdownParserToTreeMap.convertMarkdownToHtml(stringBuilder.toString());
                    html = "<body><head></head><h3>" + heading + "</h3>" + (String)html + "</body></html>";
                    try {
                        Path tempFile = Files.createTempFile(RPGCardCreator.makeSafePathFileName(heading), ".tmp", new FileAttribute[0]);
                        boolean rotated = HtmlToPdfConverter.writePDFToHtml(tempFile, (String)html, settingsMap);
                        if (rotated) {
                            rotatedFiles.add(tempFile.toFile());
                        }
                        pathAndFiles.add(tempFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return "Export failed.\n" + e.getMessage();
                    }
                }
            }
            for (File rotatedFile : rotatedFiles) {
                RPGCardCreator.rotatePDF(rotatedFile);
            }
            RPGCardCreator.mergePdfs(pathAndFiles, fileToSave);
            if (pageSize.toLowerCase().contains("us poker card")) return "PDF created successfully";
            int[] ordering = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
            MultipleCardsPerPagePDF.processFile(multipleCardsPerPageFileName, fileToSave, pageSize, ordering);
            fileToSave.delete();
            return "PDF created successfully";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Export failed.\n" + e.getMessage();
        }
    }

    private static void rotatePDF(File inputFile) throws IOException {
        PDDocument document = Loader.loadPDF(new File(inputFile.getAbsolutePath() + "r"));
        PDPageTree pages = document.getPages();
        for (PDPage page : pages) {
            int currentRotation = page.getRotation();
            int newRotation = (currentRotation - 90) % 360;
            page.setRotation(newRotation);
        }
        document.save(inputFile);
        System.out.println("PDF rotated successfully and saved to " + inputFile.getAbsolutePath());
    }

    private static String makeSafePathFileName(String input) {
        String safeName = input.replaceAll("[^a-zA-Z0-9.-]", "_");
        if (safeName.isEmpty()) {
            return "default_file";
        }
        return safeName;
    }

    private static PDType0Font loadFontFromClassPath(PDDocument document, String fontName) {
        PDType0Font font = null;
        try (InputStream fontInputStream = RPGCardCreator.class.getClassLoader().getResourceAsStream(fontName);){
            if (fontInputStream == null) {
                throw new IOException("Font file not found in classpath: " + fontName);
            }
            font = PDType0Font.load(document, fontInputStream, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return font;
    }

    public static void mergePdfs(List<Path> sourceFiles, File destinationFile) throws IOException {
        PDFMergerUtility merger = new PDFMergerUtility();
        merger.setDestinationFileName(destinationFile.getAbsolutePath());
        for (Path path : sourceFiles) {
            merger.addSource(path.toFile());
        }
        RandomAccessStreamCache.StreamCacheCreateFunction streamCache = IOUtils.createMemoryOnlyStreamCache();
        merger.mergeDocuments(streamCache);
        System.out.println("PDFs merged successfully!");
        for (Path toRemove : sourceFiles) {
            if (!toRemove.toFile().exists()) continue;
            toRemove.toFile().delete();
        }
    }

    private static Map<String, Object> ingestMarkDown(String dataSet) {
        LinkedHashMap<String, Object> rootMap = new LinkedHashMap<String, Object>();
        String[] fileNames = new String[]{"5e 2014 SRD/backgrounds feats and more.md", "5e 2014 SRD/races.md", "5e 2014 SRD/classes.md", "5e 2014 SRD/equipment.md", "5e 2014 SRD/spellcasting.md", "5e 2014 SRD/magic items.md"};
        if ("Black Flag".equals(dataSet)) {
            String[] bf = new String[]{"Black Flag/classes.md", "Black Flag/lineage and heritage.md", "Black Flag/backgrounds and talents.md", "Black Flag/spellcasting.md", "Black Flag/equipment and magic items.md", "Black Flag/monsters.md"};
            fileNames = bf;
        }
        for (String fileName : fileNames) {
            StringBuilder sb = new StringBuilder();
            try (InputStream inputStream = RPGCardCreator.class.getClassLoader().getResourceAsStream(fileName);
                 InputStreamReader isr = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(isr);){
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String markdown = sb.toString();
            MarkdownParserToTreeMap.parseToMarkdownWithStructure(rootMap, markdown);
        }
        return rootMap;
    }

    private static void createAndShowGUI() {
        frame = new JFrame("RPG Card Creator v" + version + " by Inkwell Ideas");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 550);
        frame.setLayout(new BorderLayout());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(dataSet);
        treeModel = new DefaultTreeModel(root);
        RPGCardCreator.addBranches(root, masterMap);
        tree = new JCheckBoxTree(treeModel);
        tree.addCheckChangeEventListener(new JCheckBoxTree.CheckChangeEventListener(){

            @Override
            public void checkStateChanged(JCheckBoxTree.CheckChangeEvent event) {
                System.out.println("event:" + String.valueOf(event.getSource()));
                LinkedHashMap selectedMap = null;
                String heading = null;
                for (Object pathPart : ((TreePath)event.getSource()).getPath()) {
                    Object result;
                    System.out.println("pathPart:" + String.valueOf(pathPart) + ":" + String.valueOf(pathPart.getClass()));
                    if (dataSet.equals(pathPart.toString())) {
                        selectedMap = masterMap;
                        continue;
                    }
                    if (!pathPart.toString().contains("*content*")) {
                        heading = pathPart.toString();
                    }
                    if ((result = selectedMap.get(pathPart.toString())) == null) continue;
                    if (result instanceof LinkedHashMap) {
                        LinkedHashMap tm;
                        selectedMap = tm = (LinkedHashMap)result;
                        continue;
                    }
                    if (!(result instanceof StringBuilder)) continue;
                    StringBuilder text = (StringBuilder)result;
                    textArea.setText(text.toString());
                    selectedTreePath = (TreePath)event.getSource();
                }
            }
        });
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(0.5);
        treeScrollPane = new JScrollPane(tree);
        splitPane.setLeftComponent(treeScrollPane);
        JPanel settingsPanel = RPGCardCreator.createTextAreaAndSettingsPanel();
        splitPane.setRightComponent(settingsPanel);
        frame.add((Component)splitPane, "Center");
        JPanel buttonPanel = new JPanel();
        JButton instructionsButton = new JButton("Instructions");
        instructionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextArea textArea = new JTextArea("THE TREE\nCheck the boxes of the tree for the various '*content*' entries of the\nabilities/powers/spells you'd like to make into cards. Then click 'Create PDF'.\n\nClicking a *content* node in the tree will display that item's text in the\ntextarea. You can make changes (following 'Markdown syntax' then click the \n'Save' button just under the textarea.\n\nRight-clicking a node opens a popup to let you rename it.\n\nSETTINGS'\n* Title Font Size: Font size for the text at the top of the card, in points.\n* Body Font Size: Card body font size, in points.\n* Minimum Font Size: The tool attempts to fit everything on one page. If the\n  text won't fit on one page it lowers the font size by 0.25pt, then tries\n  again. But at some point the text is too hard to read and it should be\n  left as multiple cards. This lets you configure how small it will go.\n* Border Color: Pick the color of the card's border.\n* Page Size: Print each selected item as a US Poker size card, 9 per US\n  Letter sized page, or 9 per A4 page, or as individual images in a folder.\nCHANGE DATASET\nLets you pick other data sets. Currently 'Custom' is not implemented.\n\nCREATE PDF\nClick this button to create the PDF. A file chooser will appear for you to select\nselect the filename to use.");
                textArea.setEditable(false);
                JOptionPane.showMessageDialog(frame, textArea, "Instructions", 1);
            }
        });
        buttonPanel.add(instructionsButton);
        JButton comingSoonButton = new JButton("Coming Soon");
        comingSoonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(frame, "TODO\n* Implement import of custom data.\n* More built-in data for existing datasets. (5e creatures? 5e 2024?)\n* Remember file save location.\n* Allow user to set card break location when splitting cards.\n* Add title to 2nd cards ('Long Spell Name - b').\n* When creating images, name them based on each card's title.\n", "Coming Soon", 1);
            }
        });
        buttonPanel.add(comingSoonButton);
        JButton importDataButton = new JButton("Change Dataset");
        importDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPGCardCreator.promptToImportData();
            }
        });
        buttonPanel.add(importDataButton);
        JButton createPDFButton = new JButton("Create PDF");
        createPDFButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settingsMap.put("fontSize", fontSizeSpinner.getModel().getValue());
                settingsMap.put("fontMinSize", fontMinSizeSpinner.getModel().getValue());
                settingsMap.put("fontTitleSize", fontTitleSizeSpinner.getModel().getValue());
                settingsMap.put("borderColor", borderColor[0]);
                settingsMap.put("pageSize", pageSizeComboBox.getModel().getSelectedItem());
                String message = RPGCardCreator.createPDF();
                JOptionPane.showMessageDialog(frame, message, "Export Result", message.toLowerCase().contains("success") ? 1 : 0);
            }
        });
        buttonPanel.add(createPDFButton);
        buttonPanel.setLayout(new FlowLayout());
        frame.add((Component)buttonPanel, "South");
        frame.setVisible(true);
    }

    private static void promptToImportData() {
        Object[] options = new Object[]{"Import", "Cancel"};
        String[] data = new String[]{"5e 2014 SRD", "Black Flag", "Custom"};
        JList<String> dataOptionsList = new JList<String>(data);
        dataOptionsList.setSelectionMode(0);
        dataOptionsList.setSelectedIndex(0);
        JPanel dataSelectionPanel = new JPanel();
        dataSelectionPanel.setLayout(new BoxLayout(dataSelectionPanel, 1));
        dataSelectionPanel.add(new Label("Select the data to import:"));
        dataSelectionPanel.add(dataOptionsList);
        int choice = JOptionPane.showOptionDialog(frame, dataSelectionPanel, "Import Data", 0, 3, null, options, options[0]);
        System.out.println("choice: " + choice);
        if (choice == 0) {
            RPGCardCreator.importData(dataOptionsList.getSelectedValue());
            JOptionPane.showMessageDialog(frame, "Changes saved.");
        } else if (choice == 1) {
            JOptionPane.showMessageDialog(frame, "Changes discarded.");
        } else if (choice == 2 || choice == -1) {
            JOptionPane.showMessageDialog(frame, "Operation cancelled.");
        }
    }

    private static void importData(String selectedValue) {
        System.out.println("importing data: " + selectedValue);
        masterMap = (LinkedHashMap)RPGCardCreator.ingestMarkDown(selectedValue);
        dataSet = selectedValue;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(dataSet);
        treeModel = new DefaultTreeModel(root);
        RPGCardCreator.addBranches(root, masterMap);
        tree.setModel(treeModel);
        tree.setEnabled(true);
    }

    private static JPanel createTextAreaAndSettingsPanel() {
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        textArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setMinimumSize(new Dimension(200, 200));
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(true);
        wrapperPanel.add((Component)scrollPane, "Center");
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 1;
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("saveButton:" + e.getActionCommand());
                RPGCardCreator.saveDescription();
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridheight = 1;
        settingsPanel.add((Component)saveButton, gbc);
        JLabel label = new JLabel("Export Settings");
        label.setFont(label.getFont().deriveFont(1));
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 1;
        settingsPanel.add((Component)label, gbc);
        JLabel titleFontSizeLabel = new JLabel("Title Font Size:");
        gbc.gridx = 0;
        gbc.gridy = 9;
        settingsPanel.add((Component)titleFontSizeLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 9;
        SpinnerNumberModel modelTitleFontSize = new SpinnerNumberModel(14.0, 5.0, 20.0, 0.25);
        fontTitleSizeSpinner = new JSpinner(modelTitleFontSize);
        fontTitleSizeSpinner.setMinimumSize(new Dimension(30, 20));
        settingsPanel.add((Component)fontTitleSizeSpinner, gbc);
        JLabel fontSizeLabel = new JLabel("Default Body Font Size:");
        gbc.gridx = 0;
        gbc.gridy = 10;
        settingsPanel.add((Component)fontSizeLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 10;
        SpinnerNumberModel modelFontSize = new SpinnerNumberModel(8.0, 5.0, 12.0, 0.25);
        fontSizeSpinner = new JSpinner(modelFontSize);
        fontSizeSpinner.setMinimumSize(new Dimension(30, 20));
        settingsPanel.add((Component)fontSizeSpinner, gbc);
        JLabel fontMinSizeLabel = new JLabel("Minimum Font Size:");
        gbc.gridx = 0;
        gbc.gridy = 11;
        settingsPanel.add((Component)fontMinSizeLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 11;
        SpinnerNumberModel modelMinFontSize = new SpinnerNumberModel(6.5, 4.0, 12.0, 0.1);
        fontMinSizeSpinner = new JSpinner(modelMinFontSize);
        fontMinSizeSpinner.setMinimumSize(new Dimension(30, 20));
        settingsPanel.add((Component)fontMinSizeSpinner, gbc);
        final JLabel borderColorLabel = new JLabel("Border Color:");
        final JPanel borderColorPanel = new JPanel();
        borderColorPanel.add(borderColorLabel);
        borderColor = new Color[]{Color.GRAY};
        borderColorPanel.setBackground(borderColor[0]);
        gbc.gridx = 0;
        gbc.gridy = 12;
        settingsPanel.add((Component)borderColorPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 12;
        JButton borderColorButton = new JButton("Choose Color");
        borderColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(frame, "Choose Background Color", borderColor[0]);
                if (newColor != null) {
                    System.out.println(newColor);
                    RPGCardCreator.borderColor[0] = newColor;
                    borderColorPanel.setBackground(borderColor[0]);
                    if (borderColor[0].getRed() + borderColor[0].getGreen() + borderColor[0].getBlue() < 392) {
                        borderColorLabel.setForeground(Color.WHITE);
                    } else {
                        borderColorLabel.setForeground(Color.BLACK);
                    }
                }
            }
        });
        settingsPanel.add((Component)borderColorButton, gbc);
        JLabel pageSizeLabel = new JLabel("Page Size:");
        gbc.gridx = 0;
        gbc.gridy = 13;
        settingsPanel.add((Component)pageSizeLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 13;
        pageSizeComboBox = new JComboBox<String>(new String[]{"Letter", "A4", "US Poker Card", "Images"});
        pageSizeComboBox.setSelectedIndex(0);
        settingsPanel.add(pageSizeComboBox, gbc);
        settingsMap.put("fontSize", fontSizeSpinner.getModel().getValue());
        settingsMap.put("fontMinSize", fontMinSizeSpinner.getModel().getValue());
        settingsMap.put("fontTitleSize", fontTitleSizeSpinner.getModel().getValue());
        settingsMap.put("borderColor", borderColor[0]);
        settingsMap.put("pageSize", pageSizeComboBox.getModel().getSelectedItem());
        wrapperPanel.add((Component)settingsPanel, "South");
        return wrapperPanel;
    }

    private static void saveDescription() {
        LinkedHashMap selectedMap = null;
        for (Object pathPart : selectedTreePath.getPath()) {
            Object result;
            if (dataSet.equals(pathPart.toString())) {
                selectedMap = masterMap;
                continue;
            }
            if (!pathPart.toString().contains("*content*")) {
                // empty if block
            }
            if ((result = selectedMap.get(pathPart.toString())) == null) continue;
            if (result instanceof LinkedHashMap) {
                LinkedHashMap tm;
                selectedMap = tm = (LinkedHashMap)result;
                continue;
            }
            if (!(result instanceof StringBuilder)) continue;
            StringBuilder sb = (StringBuilder)result;
            sb.delete(0, sb.length());
            sb.append(textArea.getText());
        }
    }

    static void addBranches(DefaultMutableTreeNode root, LinkedHashMap<String, Object> map) {
        for (String key : map.keySet()) {
            DefaultMutableTreeNode branch = new DefaultMutableTreeNode(key);
            root.add(branch);
            Object value = map.get(key);
            if (value == null || !(value instanceof LinkedHashMap)) continue;
            RPGCardCreator.addBranches(branch, (LinkedHashMap)value);
        }
    }

    static {
        version = 1.01;
        settingsMap = new HashMap();
        dataSet = "5e 2014 SRD";
    }
}

