/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.DOMUtil;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxForm;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.ArrayUtil;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PdfBoxPerDocumentFormState {
    private static final String DEFAULT_APPEARANCE = "q\nQ\n";
    private final Map<Element, PdfBoxForm> forms = new HashMap<Element, PdfBoxForm>();
    private final List<PdfBoxForm.Control> controls = new ArrayList<PdfBoxForm.Control>();
    private final Set<Element> seenControls = new HashSet<Element>();
    private final Map<PDFont, String> controlFonts = new HashMap<PDFont, String>();
    private final Map<PdfBoxForm.CheckboxStyle, PDAppearanceStream> checkboxAppearances = new EnumMap<PdfBoxForm.CheckboxStyle, PDAppearanceStream>(PdfBoxForm.CheckboxStyle.class);
    private PDAppearanceStream checkboxOffAppearance;
    private PDAppearanceStream radioBoxOffAppearance;
    private PDAppearanceStream radioBoxOnAppearance;
    private PDAppearanceStream signatureAppearance;
    private PDResources checkBoxFontResource;

    public PDAppearanceStream getCheckboxStyle(PdfBoxForm.CheckboxStyle style) {
        return this.checkboxAppearances.get((Object)style);
    }

    public PDAppearanceStream getCheckboxOffStream() {
        return this.checkboxOffAppearance;
    }

    public PDAppearanceStream getRadioOffStream() {
        return this.radioBoxOffAppearance;
    }

    public PDAppearanceStream getRadioOnStream() {
        return this.radioBoxOnAppearance;
    }

    public PDAppearanceStream getSignatureStream() {
        return this.signatureAppearance;
    }

    public void addFormIfRequired(Box box, PdfBoxOutputDevice od) {
        if (!this.forms.containsKey(box.getElement())) {
            PdfBoxForm frm = PdfBoxForm.createForm(box.getElement(), this, od);
            this.forms.put(box.getElement(), frm);
        }
    }

    public void addControlIfRequired(Box box, PDPage page, AffineTransform transform, RenderingContext c, float pageHeight) {
        if (!this.seenControls.contains(box.getElement())) {
            this.controls.add(new PdfBoxForm.Control(box, page, new AffineTransform(transform), c, pageHeight));
            this.seenControls.add(box.getElement());
        }
    }

    private String getControlFont(SharedContext sharedContext, PdfBoxForm.Control ctrl, RenderingContext renderingContext) {
        String fontName;
        PDFont fnt = ((PdfBoxFSFont)sharedContext.getFont(ctrl.box.getStyle().getFont(renderingContext))).getFontDescriptions().get(0).getFont();
        if (!this.controlFonts.containsKey(fnt)) {
            fontName = "OpenHTMLFont" + this.controlFonts.size();
            this.controlFonts.put(fnt, fontName);
        } else {
            fontName = this.controlFonts.get(fnt);
        }
        return fontName;
    }

    private void createSignatureAppearanceStreams(PDDocument writer) {
        this.signatureAppearance = PdfBoxForm.createCheckboxAppearance(DEFAULT_APPEARANCE, writer, this.checkBoxFontResource);
    }

    private void createCheckboxAppearanceStreams(PDDocument writer, PdfBoxForm.Control ctrl) {
        PdfBoxForm.CheckboxStyle style = PdfBoxForm.CheckboxStyle.fromIdent(ctrl.box.getStyle().getIdent(CSSName.FS_CHECKBOX_STYLE));
        this.checkboxAppearances.computeIfAbsent(style, k -> PdfBoxForm.createCheckboxAppearance(style, writer, this.checkBoxFontResource));
        if (this.checkboxOffAppearance == null) {
            this.checkboxOffAppearance = PdfBoxForm.createCheckboxAppearance(DEFAULT_APPEARANCE, writer, this.checkBoxFontResource);
        }
    }

    private void createRadioboxAppearanceStream(PDDocument writer) {
        if (this.radioBoxOffAppearance == null) {
            this.radioBoxOffAppearance = PdfBoxForm.createCheckboxAppearance(DEFAULT_APPEARANCE, writer, this.checkBoxFontResource);
        }
        if (this.radioBoxOnAppearance == null) {
            this.radioBoxOnAppearance = PdfBoxForm.createCheckboxAppearance(PdfBoxForm.CheckboxStyle.DIAMOND, writer, this.checkBoxFontResource);
        }
    }

    private void createCheckboxFontResource() {
        if (this.checkBoxFontResource == null) {
            this.checkBoxFontResource = new PDResources();
            this.checkBoxFontResource.put(COSName.getPDFName("OpenHTMLZap"), new PDType1Font(Standard14Fonts.FontName.ZAPF_DINGBATS));
        }
    }

    public void processControls(SharedContext sharedContext, PDDocument writer, Box root, RenderingContext renderingContext) {
        for (PdfBoxForm.Control ctrl : this.controls) {
            PdfBoxForm frm = this.findEnclosingForm(ctrl.box.getElement());
            String fontName = null;
            if (ctrl.box.getElement().getAttribute("type").equals("text") && ctrl.box.getElement().getAttribute("class").contains("signature")) {
                this.createSignatureAppearanceStreams(writer);
            } else if (!ArrayUtil.isOneOf(ctrl.box.getElement().getAttribute("type"), "checkbox", "radio", "hidden")) {
                fontName = this.getControlFont(sharedContext, ctrl, renderingContext);
            } else if (ctrl.box.getElement().getAttribute("type").equals("checkbox")) {
                this.createCheckboxFontResource();
                this.createCheckboxAppearanceStreams(writer, ctrl);
            } else if (ctrl.box.getElement().getAttribute("type").equals("radio")) {
                this.createCheckboxFontResource();
                this.createRadioboxAppearanceStream(writer);
            }
            if (frm == null) continue;
            frm.addControl(ctrl, fontName);
        }
        if (!this.forms.isEmpty()) {
            this.processForms(writer, root);
        }
    }

    private void processForms(PDDocument writer, Box root) {
        PDResources resources = new PDResources();
        resources.put(COSName.HELV, new PDType1Font(Standard14Fonts.FontName.HELVETICA));
        resources.put(COSName.ZA_DB, new PDType1Font(Standard14Fonts.FontName.ZAPF_DINGBATS));
        for (Map.Entry<PDFont, String> fnt : this.controlFonts.entrySet()) {
            resources.put(COSName.getPDFName(fnt.getValue()), fnt.getKey());
        }
        int start = 0;
        PDAcroForm acro = new PDAcroForm(writer);
        acro.setDefaultAppearance("/Helv 0 Tf 0 g");
        acro.setNeedAppearances(Boolean.TRUE);
        acro.setDefaultResources(resources);
        writer.getDocumentCatalog().setAcroForm(acro);
        for (PdfBoxForm frm : this.forms.values()) {
            try {
                start = 1 + frm.process(acro, start, root);
            }
            catch (IOException e) {
                throw new PdfContentStreamAdapter.PdfException("processControls", e);
            }
        }
    }

    private PdfBoxForm findEnclosingForm(Node e) {
        Element frmElement = DOMUtil.findClosestEnclosingElementWithNodeName(e, "form");
        if (frmElement != null && this.forms.containsKey(frmElement)) {
            return this.forms.get(frmElement);
        }
        XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.GENERAL_PDF_FOUND_FORM_CONTROL_WITH_NO_ENCLOSING_FORM, e.getNodeName());
        return null;
    }
}

