/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.pdfboxout.FontRun;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxRawPDFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;

public class PdfBoxTextRenderer
implements TextRenderer {
    private static final float TEXT_MEASURING_DELTA = 0.01f;
    private static final int FAST_FONT_RUN_MINIMUM_LENGTH = 32;
    private static final int FAST_FONT_RUN_PARTITION_FACTOR = 3;
    private BidiReorderer _reorderer;
    private boolean _loggedMissingFont = false;
    private boolean _loggedMissingMetrics = false;

    public void setup(FontContext context, BidiReorderer reorderer) {
        this._reorderer = reorderer;
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, null);
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string, float x, float y, JustificationInfo info) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, info);
    }

    @Override
    public FSFontMetrics getFSFontMetrics(FontContext context, FSFont font, String string) {
        List<PdfBoxFontResolver.FontDescription> descrs = ((PdfBoxFSFont)font).getFontDescriptions();
        float size = font.getSize2D();
        PdfBoxFSFontMetrics result = new PdfBoxFSFontMetrics();
        float largestAscent = -3.4028235E38f;
        float largestDescent = -3.4028235E38f;
        float largestStrikethroughOffset = -3.4028235E38f;
        float largestStrikethroughThickness = -3.4028235E38f;
        float largestUnderlinePosition = -3.4028235E38f;
        float largestUnderlineThickness = -3.4028235E38f;
        for (PdfBoxFontResolver.FontDescription des : descrs) {
            PdfBoxRawPDFontMetrics metrics = des.getFontMetrics();
            if (metrics == null) {
                if (this._loggedMissingMetrics) continue;
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_FONT_METRICS_NOT_AVAILABLE, des);
                this._loggedMissingMetrics = true;
                continue;
            }
            float loopAscent = metrics._ascent;
            float loopDescent = metrics._descent;
            float loopStrikethroughOffset = metrics._strikethroughOffset;
            float loopStrikethroughThickness = metrics._strikethroughThickness;
            float loopUnderlinePosition = metrics._underlinePosition;
            float loopUnderlineThickness = metrics._underlineThickness;
            if (loopAscent > largestAscent) {
                largestAscent = loopAscent;
            }
            if (loopDescent > largestDescent) {
                largestDescent = loopDescent;
            }
            if (loopStrikethroughOffset > largestStrikethroughOffset) {
                largestStrikethroughOffset = loopStrikethroughOffset;
            }
            if (loopStrikethroughThickness > largestStrikethroughThickness) {
                largestStrikethroughThickness = loopStrikethroughThickness;
            }
            if (loopUnderlinePosition > largestUnderlinePosition) {
                largestUnderlinePosition = loopUnderlinePosition;
            }
            if (!(loopUnderlineThickness > largestUnderlineThickness)) continue;
            largestUnderlineThickness = loopUnderlineThickness;
        }
        result.setAscent(largestAscent / 1000.0f * size);
        result.setDescent(largestDescent / 1000.0f * size);
        result.setStrikethroughOffset(largestStrikethroughOffset / 1000.0f * size);
        if (largestStrikethroughThickness > 0.0f) {
            result.setStrikethroughThickness(largestStrikethroughThickness / 1000.0f * size);
        } else {
            result.setStrikethroughThickness(size / 12.0f);
        }
        result.setUnderlineOffset(largestUnderlinePosition / 1000.0f * size);
        result.setUnderlineThickness(largestUnderlineThickness / 1000.0f * size);
        return result;
    }

    public static boolean isJustificationSpace(int c) {
        return c == 32 || c == 160 || c == 12288;
    }

    private static ReplacementChar getReplacementChar(FSFont font) {
        String replaceStr = ThreadCtx.get().sharedContext().getReplacementText();
        List<PdfBoxFontResolver.FontDescription> descriptions = ((PdfBoxFSFont)font).getFontDescriptions();
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = replaceStr;
                replace.fontDescription = des;
                return replace;
            }
            catch (Exception replace) {
            }
        }
        replaceStr = " ";
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = " ";
                replace.fontDescription = des;
                return replace;
            }
            catch (Exception exception) {
            }
        }
        XRLog.log(Level.INFO, LogMessageId.LogMessageId0Param.GENERAL_PDF_SPECIFIED_FONTS_DONT_CONTAIN_A_SPACE_CHARACTER);
        ReplacementChar replace = new ReplacementChar();
        replace.replacement = "";
        replace.fontDescription = descriptions.get(0);
        return replace;
    }

    public static List<FontRun> divideIntoFontRuns(PdfBoxFSFont font, String str, BidiReorderer reorderer) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PdfBoxFontResolver.FontDescription> fontDescriptions = font.getFontDescriptions();
        ArrayList<FontRun> runs = new ArrayList<FontRun>();
        FontRun currentRun = null;
        int i = 0;
        while (i < str.length()) {
            int unicode = str.codePointAt(i);
            i += Character.charCount(unicode);
            String ch = String.valueOf(Character.toChars(unicode));
            if (!OpenUtil.isSafeFontCodePointToPrint(unicode)) continue;
            PdfBoxFontResolver.FontDescription applicableDescription = null;
            for (PdfBoxFontResolver.FontDescription description : fontDescriptions) {
                if (description.getFont() == null) continue;
                try {
                    description.getFont().getStringWidth(ch);
                    applicableDescription = description;
                }
                catch (IllegalArgumentException e) {
                    if (!reorderer.isLiveImplementation()) {
                        continue;
                    }
                }
                catch (IOException e) {
                    continue;
                }
                if (applicableDescription == null) {
                    String deshaped = reorderer.deshapeText(ch);
                    try {
                        description.getFont().getStringWidth(deshaped);
                        applicableDescription = description;
                        ch = deshaped;
                    }
                    catch (IOException | IllegalArgumentException e1) {
                        continue;
                    }
                }
                if (currentRun == null) {
                    currentRun = new FontRun(applicableDescription);
                } else if (applicableDescription != currentRun.description) {
                    currentRun.string = stringBuilder.toString();
                    runs.add(currentRun);
                    currentRun = new FontRun(applicableDescription);
                    stringBuilder = new StringBuilder();
                }
                if (PdfBoxTextRenderer.isJustificationSpace(unicode)) {
                    ++currentRun.spaceCharacterCount;
                } else {
                    ++currentRun.otherCharacterCount;
                }
                stringBuilder.append(ch);
                break;
            }
            if (applicableDescription != null || !OpenUtil.isCodePointPrintable(unicode)) continue;
            ReplacementChar replace = PdfBoxTextRenderer.getReplacementChar(font);
            if (currentRun == null) {
                currentRun = new FontRun(replace.fontDescription);
            } else if (replace.fontDescription != currentRun.description) {
                currentRun.string = stringBuilder.toString();
                runs.add(currentRun);
                currentRun = new FontRun(replace.fontDescription);
                stringBuilder = new StringBuilder();
            }
            if (Character.isSpaceChar(unicode) || Character.isWhitespace(unicode)) {
                ++currentRun.spaceCharacterCount;
                stringBuilder.append(' ');
                continue;
            }
            ++currentRun.otherCharacterCount;
            stringBuilder.append(replace.replacement);
        }
        if (stringBuilder.length() > 0) {
            assert (currentRun != null);
            currentRun.string = stringBuilder.toString();
            runs.add(currentRun);
        }
        return runs;
    }

    private float getStringWidthSlow(PdfBoxFSFont font, String str) {
        List<FontRun> runs = PdfBoxTextRenderer.divideIntoFontRuns(font, str, this._reorderer);
        float strWidth = 0.0f;
        for (FontRun run : runs) {
            try {
                strWidth += run.description.getFont().getStringWidth(run.string);
            }
            catch (Exception e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.RENDER_BUG_FONT_DIDNT_CONTAIN_EXPECTED_CHARACTER, e);
            }
        }
        return strWidth;
    }

    @Override
    public int getWidth(FontContext context, FSFont font, String string) {
        PdfBoxFSFont pdfBoxFont = (PdfBoxFSFont)font;
        String effectiveString = TextRenderer.getEffectivePrintableString(string);
        if (pdfBoxFont.getFontDescriptions() == null || pdfBoxFont.getFontDescriptions().isEmpty()) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.RENDER_FONT_LIST_IS_EMPTY);
            return 0;
        }
        Optional<PdfBoxFontResolver.FontDescription> description = this.getFontDescription(pdfBoxFont);
        if (!description.isPresent()) {
            return 0;
        }
        float result = 0.0f;
        try {
            result = description.get().getFont().getStringWidth(effectiveString) / 1000.0f * pdfBoxFont.getSize2D();
        }
        catch (IllegalArgumentException e) {
            if (effectiveString.length() < 32) {
                result = this.getStringWidthSlow(pdfBoxFont, effectiveString) / 1000.0f * pdfBoxFont.getSize2D();
            } else {
                for (int i = 0; i < 3; ++i) {
                    int chunkSize = effectiveString.length() / 3;
                    int left = i * chunkSize;
                    int right = i + 1 == 3 ? effectiveString.length() : (i + 1) * chunkSize;
                    String chunk = effectiveString.substring(left, right);
                    result += (float)this.getWidth(context, pdfBoxFont, chunk);
                }
            }
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("getWidth", e);
        }
        if ((double)result - Math.floor(result) < (double)0.01f) {
            return (int)result;
        }
        return (int)Math.ceil(result);
    }

    private Optional<PdfBoxFontResolver.FontDescription> getFontDescription(PdfBoxFSFont pdfBoxFont) {
        for (PdfBoxFontResolver.FontDescription d : pdfBoxFont.getFontDescriptions()) {
            if (d.getFont() != null) {
                return Optional.of(d);
            }
            this.logMissingFont(d);
        }
        return Optional.empty();
    }

    private void logMissingFont(PdfBoxFontResolver.FontDescription fontDescription) {
        if (this._loggedMissingFont) {
            return;
        }
        XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.RENDER_FONT_IS_NULL, fontDescription);
        this._loggedMissingFont = true;
    }

    private static class ReplacementChar {
        String replacement;
        PdfBoxFontResolver.FontDescription fontDescription;

        private ReplacementChar() {
        }
    }
}

