/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout.fontstore;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.FontFamily;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.fontstore.FontUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public abstract class AbstractFontStore {
    public abstract PdfBoxFontResolver.FontDescription resolveFont(SharedContext var1, String var2, float var3, IdentValue var4, IdentValue var5, IdentValue var6);

    public static class BuiltinFontStore
    extends AbstractFontStore {
        final Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> _fontFamilies = BuiltinFontStore.createInitialFontMap();

        public BuiltinFontStore(PDDocument doc) {
        }

        static Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> createInitialFontMap() {
            HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result = new HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>>();
            BuiltinFontStore.addCourier(result);
            BuiltinFontStore.addTimes(result);
            BuiltinFontStore.addHelvetica(result);
            BuiltinFontStore.addSymbol(result);
            BuiltinFontStore.addZapfDingbats(result);
            return result;
        }

        static void addCourier(HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily<PdfBoxFontResolver.FontDescription> courier = new FontFamily<PdfBoxFontResolver.FontDescription>("Courier");
            courier.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.COURIER_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
            courier.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.COURIER_OBLIQUE), IdentValue.OBLIQUE, 400));
            courier.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.COURIER_BOLD), IdentValue.NORMAL, 700));
            courier.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.COURIER), IdentValue.NORMAL, 400));
            result.put("DialogInput", courier);
            result.put("Monospaced", courier);
            result.put("Courier", courier);
        }

        static void addTimes(HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily<PdfBoxFontResolver.FontDescription> times = new FontFamily<PdfBoxFontResolver.FontDescription>("Times");
            times.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.TIMES_BOLD_ITALIC), IdentValue.ITALIC, 700));
            times.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.TIMES_ITALIC), IdentValue.ITALIC, 400));
            times.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.TIMES_BOLD), IdentValue.NORMAL, 700));
            times.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.TIMES_ROMAN), IdentValue.NORMAL, 400));
            result.put("Serif", times);
            result.put("TimesRoman", times);
        }

        static void addHelvetica(HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily<PdfBoxFontResolver.FontDescription> helvetica = new FontFamily<PdfBoxFontResolver.FontDescription>("Helvetica");
            helvetica.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
            helvetica.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.HELVETICA_OBLIQUE), IdentValue.OBLIQUE, 400));
            helvetica.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD), IdentValue.NORMAL, 700));
            helvetica.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.HELVETICA), IdentValue.NORMAL, 400));
            result.put("Dialog", helvetica);
            result.put("SansSerif", helvetica);
            result.put("Helvetica", helvetica);
        }

        static void addSymbol(Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily<PdfBoxFontResolver.FontDescription> fontFamily = new FontFamily<PdfBoxFontResolver.FontDescription>("Symbol");
            fontFamily.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.SYMBOL), IdentValue.NORMAL, 400));
            result.put("Symbol", fontFamily);
        }

        static void addZapfDingbats(Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily<PdfBoxFontResolver.FontDescription> fontFamily = new FontFamily<PdfBoxFontResolver.FontDescription>("ZapfDingbats");
            fontFamily.addFontDescription(new PdfBoxFontResolver.FontDescription(new PDType1Font(Standard14Fonts.FontName.ZAPF_DINGBATS), IdentValue.NORMAL, 400));
            result.put("ZapfDingbats", fontFamily);
        }

        @Override
        public PdfBoxFontResolver.FontDescription resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
            String normalizedFontFamily = FontUtil.normalizeFontFamily(fontFamily);
            FontFamily<PdfBoxFontResolver.FontDescription> family = this._fontFamilies.get(normalizedFontFamily);
            if (family != null) {
                return family.match(FontResolverHelper.convertWeightToInt(weight), style);
            }
            return null;
        }
    }

    public static class EmptyFontStore
    extends AbstractFontStore {
        @Override
        public PdfBoxFontResolver.FontDescription resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
            return null;
        }
    }
}

